/* 
 * File:   KS0108-PIC16.h
 * Author: phil
 *
 * Created on 10 January 2015, 5:20 PM
 */

#include "Reflow.h" 


#define KS0108_DATA_WRITE(_KS0108_Data)	{SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_DATA, APP_LCD_DATA_LOC); SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_DATA, (_KS0108_Data<<8), APP_LCD_DATA_LOC);}
#define KS0108_DATA_READ(_KS0108_Data)	{_KS0108_Data = ((SYS_PORTS_Read(PORTS_ID_0, APP_LCD_PORT_DATA) & 0xFF00)>>8);}

#define KS0108_Read SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_INPUT, APP_LCD_PORT_DATA, APP_LCD_DATA_LOC )
#define KS0108_Write SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_DATA, APP_LCD_DATA_LOC )
// RB3  = LCD Reset - Active Low (output)   // KS0108_LCD_RST 8
// RB4  = LCD Enable (output)               // KS0108_LCD_E 16
// RB5  = LCD Chip Select 1 (output)        // KS0108_LCD_CS1 32
// RD5 = LCD_RW (output)                    // KS0108_LCD_RW 32
// RD6 = LCD_RS (output)                    // KS0108_LCD_RS 64
// RD7 = LCD_CS (output)                    // KS0108_LCD_CS0 128
#define KS0108_Write_RST SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RESET, KS0108_LCD_RST )
#define KS0108_Write_EN SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_ENABLE, KS0108_LCD_E )
#define KS0108_Write_CS0 SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_CS0, KS0108_LCD_CS0 )
#define KS0108_Write_CS1 SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_CS1, KS0108_LCD_CS1 )
#define KS0108_Write_RW SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RW, KS0108_LCD_RW)
#define KS0108_Write_RS SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RS, KS0108_LCD_RS)



#define KS0108_ASSERT_RESET  SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RESET, KS0108_LCD_RST)
#define KS0108_CLEAR_RESET   SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RESET, KS0108_LCD_RST, KS0108_LCD_RST)
#define KS0108_ASSERT_ENABLE SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_ENABLE, KS0108_LCD_E, KS0108_LCD_E)
#define KS0108_CLEAR_ENABLE  SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_ENABLE, KS0108_LCD_E)
#define KS0108_ASSERT_CS0    SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_CS0, KS0108_LCD_CS0)
#define KS0108_CLEAR_CS0     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_CS0, KS0108_LCD_CS0, KS0108_LCD_CS0)
#define KS0108_ASSERT_CS1    SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_CS1, KS0108_LCD_CS1)
#define KS0108_CLEAR_CS1     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_CS1, KS0108_LCD_CS1, KS0108_LCD_CS1)
#define KS0108_ASSERT_RW     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RW, KS0108_LCD_RW, KS0108_LCD_RW)
#define KS0108_CLEAR_RW      SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RW, KS0108_LCD_RW)
#define KS0108_ASSERT_RS     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RS, KS0108_LCD_RS, KS0108_LCD_RS)
#define KS0108_CLEAR_RS      SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RS, KS0108_LCD_RS)

#define TEST_CLEAR_LED       SYS_PORTS_Clear(PORTS_ID_0, APP_HEARTBEAT_PORT, APP_HEARTBEAT_PIN)
#define TEST_SET_LED         SYS_PORTS_Set(PORTS_ID_0, APP_HEARTBEAT_PORT, APP_HEARTBEAT_PIN, APP_HEARTBEAT_PIN)



/* these work with the small LCD*/
//#define KS0108_E_H 5
//#define KS0108_E_L 5
//#define KS0108_EN_H 5
//#define KS0108_EN_L 5

/* these work with the small LCD*/
#define KS0108_E_H 2
#define KS0108_E_L 2
#define KS0108_EN_H 2
#define KS0108_EN_L 2


#define DISPLAY_STATUS_BUSY 0x80

extern unsigned char screen_x, screen_y;
//-------------------------------------------------------------------------------------------------
// Delay function
//-------------------------------------------------------------------------------------------------

void GLCD_InitializePorts(void);
void GLCD_WriteCommand(unsigned char commandToWrite, unsigned char controller);
unsigned char GLCD_ReadData(void);
void GLCD_WriteData(unsigned char dataToWrite);
unsigned char GLCD_ReadByteFromROMMemory(char * ptr);